using System;
using System.Collections;

namespace BeWise.SharpBuilderTools.Helpers {
	public class SortHelper : IComparer {

		/**************************************************************/
		/*                        Private
		/**************************************************************/

		private bool fAscending = true;
		private bool fCaseSensitive = true;

		/**************************************************************/
		/*                        Public
		/**************************************************************/
		public int Compare(object x,object y) {
			string _X = (string) x;
			string _Y = (string) y;

			if (!CaseSensitive) {
				_X = (_X as string).ToUpper();
				_Y = (_Y as string).ToUpper();
			}

			if (Ascending) {
				return string.Compare(_X, _Y);
			}
			else {
				return string.Compare(_Y, _X);
			}
		}

		/**************************************************************/
		/*                        Properties
		/**************************************************************/

		public bool Ascending {
			get {
				return fAscending;
			}

			set {
				fAscending = value;
			}
		}

		public bool CaseSensitive {
			get {
				return fCaseSensitive;
			}

			set {
				fCaseSensitive = value;
			}
		}
	}
}
